/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.mixin;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.entity.IllusionerEntityAccess;
import com.faboslav.friendsandfoes.mixin.BlindTargetGoalFactory;
import com.faboslav.friendsandfoes.util.RandomGenerator;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1379;
import net.minecraft.class_1380;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1581;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1617;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3763;
import net.minecraft.class_3988;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={class_1581.class})
public abstract class IllusionerEntityMixin
extends class_1617
implements class_1603,
IllusionerEntityAccess {
    private static final int MAX_ILLUSIONS_COUNT = 9;
    private static final int ILLUSION_LIFETIME_TICKS = 600;
    private static final int INVISIBILITY_TICKS = 60;
    private static final String IS_ILLUSION_NBT_NAME = "IsIllusion";
    private static final String WAS_ATTACKED_NBT_NAME = "WasAttacked";
    private static final String TICKS_UNTIL_DESPAWN_NBT_NAME = "TicksUntilDespawn";
    private static final String TICKS_UNTIL_CAN_CREATE_ILLUSIONS_NBT_NAME = "TicksUntilCanCreateIllusions";
    private static final class_2940<Boolean> IS_ILLUSION = class_2945.method_12791(IllusionerEntityMixin.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> WAS_ATTACKED = class_2945.method_12791(IllusionerEntityMixin.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> TICKS_UNTIL_DESPAWN = class_2945.method_12791(IllusionerEntityMixin.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TICKS_UNTIL_CAN_CREATE_ILLUSIONS = class_2945.method_12791(IllusionerEntityMixin.class, (class_2941)class_2943.field_13327);
    private class_1581 illusioner = null;

    protected IllusionerEntityMixin(class_1299<? extends class_1617> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public void method_5693() {
        super.method_5693();
        if (!FriendsAndFoes.getConfig().enableIllusioner) {
            return;
        }
        this.field_6011.method_12784(IS_ILLUSION, (Object)false);
        this.field_6011.method_12784(WAS_ATTACKED, (Object)false);
        this.field_6011.method_12784(TICKS_UNTIL_DESPAWN, (Object)0);
        this.field_6011.method_12784(TICKS_UNTIL_CAN_CREATE_ILLUSIONS, (Object)0);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (!FriendsAndFoes.getConfig().enableIllusioner) {
            return;
        }
        nbt.method_10556(IS_ILLUSION_NBT_NAME, this.isIllusion());
        nbt.method_10556(WAS_ATTACKED_NBT_NAME, this.wasAttacked());
        nbt.method_10569(TICKS_UNTIL_DESPAWN_NBT_NAME, this.getTicksUntilDespawn());
        nbt.method_10569(TICKS_UNTIL_CAN_CREATE_ILLUSIONS_NBT_NAME, this.getTicksUntilCanCreateIllusions());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (!FriendsAndFoes.getConfig().enableIllusioner) {
            return;
        }
        this.setIsIllusion(nbt.method_10577(IS_ILLUSION_NBT_NAME));
        this.setWasAttacked(nbt.method_10577(WAS_ATTACKED_NBT_NAME));
        this.setTicksUntilDespawn(nbt.method_10550(TICKS_UNTIL_DESPAWN_NBT_NAME));
        this.setTicksUntilCanCreateIllusions(nbt.method_10550(TICKS_UNTIL_CAN_CREATE_ILLUSIONS_NBT_NAME));
    }

    @Override
    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1617.class_1619((class_1617)this));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1439.class, 8.0f, 0.6, 1.0));
        if (!FriendsAndFoes.getConfig().enableIllusioner || !this.isIllusion()) {
            this.field_6201.method_6277(3, (class_1352)BlindTargetGoalFactory.newBlindTargetGoal((class_1581)this));
        }
        this.field_6201.method_6277(4, (class_1352)new class_1380((class_1588)this, 0.5, 20, 15.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1379((class_1314)this, 0.6));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{class_3763.class}).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true).method_6330(300));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, false).method_6330(300));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_3988.class, false).method_6330(300));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!FriendsAndFoes.getConfig().enableIllusioner) {
            return;
        }
        if (this.method_37908().method_8608()) {
            return;
        }
        if (this.getTicksUntilCanCreateIllusions() > 0) {
            this.setTicksUntilCanCreateIllusions(this.getTicksUntilCanCreateIllusions() - 1);
        }
        if ((this.method_5968() instanceof class_1657 || this.method_5968() instanceof class_1439) && this.wasAttacked() && this.getTicksUntilCanCreateIllusions() == 0) {
            this.createIllusions();
        }
        if (this.wasAttacked() && this.method_5968() == null && this.getTicksUntilCanCreateIllusions() < 200) {
            this.setWasAttacked(false);
            this.setTicksUntilCanCreateIllusions(0);
        }
    }

    @Override
    public void method_6007() {
        boolean isIllusionerNonExistingOrDead;
        super.method_6007();
        if (!FriendsAndFoes.getConfig().enableIllusioner) {
            return;
        }
        if (this.method_37908().method_8608() || !this.isIllusion()) {
            return;
        }
        if (this.getTicksUntilDespawn() > 0) {
            this.setTicksUntilDespawn(this.getTicksUntilDespawn() - 1);
        }
        boolean bl = isIllusionerNonExistingOrDead = this.getIllusioner() != null && !this.getIllusioner().method_5805();
        if (this.getTicksUntilDespawn() == 0 || isIllusionerNonExistingOrDead) {
            this.discardIllusion();
        }
    }

    public boolean method_6054() {
        if (!FriendsAndFoes.getConfig().enableIllusioner) {
            return super.method_6054();
        }
        return !this.isIllusion();
    }

    protected boolean method_27071() {
        if (!FriendsAndFoes.getConfig().enableIllusioner) {
            return super.method_27071();
        }
        return !this.isIllusion();
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!FriendsAndFoes.getConfig().enableIllusioner) {
            return super.method_5643(source, amount);
        }
        if (source.method_5529() instanceof class_1581 || this.isIllusion() && !(source.method_5529() instanceof class_1309)) {
            return false;
        }
        if (this.method_37908().method_8608() || source.method_5529() instanceof class_1657 && !this.isIllusion() && ((class_1657)source.method_5529()).method_31549().field_7477) {
            return super.method_5643(source, amount);
        }
        if (this.isIllusion()) {
            this.discardIllusion();
            return false;
        }
        if ((source.method_5529() instanceof class_1657 || source.method_5529() instanceof class_1439) && this.getTicksUntilCanCreateIllusions() == 0) {
            this.createIllusions();
        }
        return super.method_5643(source, amount);
    }

    private void discardIllusion() {
        this.playMirrorSound();
        this.spawnCloudParticles();
        this.method_31472();
    }

    private void createIllusions() {
        this.setWasAttacked(true);
        this.setTicksUntilCanCreateIllusions(600);
        this.playMirrorSound();
        class_243 illusionerPosition = this.method_19538();
        float slice = 0.69813174f;
        int radius = 9;
        int randomPoint = RandomGenerator.generateInt(0, 8);
        for (int point = 0; point < 9; ++point) {
            boolean teleportResult;
            float angle = slice * (float)point;
            int x = (int)(illusionerPosition.method_10216() + (double)((float)radius * class_3532.method_15362((float)angle)));
            int y = (int)illusionerPosition.method_10214();
            int z = (int)(illusionerPosition.method_10215() + (double)((float)radius * class_3532.method_15374((float)angle)));
            this.createIllusion(x, y, z);
            if (randomPoint != point || !(teleportResult = this.tryToTeleport(x, y, z))) continue;
            this.method_6092(new class_1293(class_1294.field_5905, 60));
            this.spawnCloudParticles();
        }
    }

    private void createIllusion(int x, int y, int z) {
        class_1581 illusioner = (class_1581)this;
        class_1581 illusion = (class_1581)class_1299.field_6065.method_5883(this.method_37908());
        illusion.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
        IllusionerEntityAccess illusionerAccess = (IllusionerEntityAccess)illusion;
        illusionerAccess.setIsIllusion(true);
        illusionerAccess.setIllusioner(illusioner);
        illusionerAccess.setTicksUntilDespawn(600);
        illusion.method_6033(this.method_6063());
        illusion.method_5719((class_1297)illusioner);
        illusion.method_5980(illusioner.method_5968());
        boolean teleportResult = illusionerAccess.tryToTeleport(x, y, z);
        if (teleportResult) {
            this.method_5770().method_8649((class_1297)illusion);
            illusionerAccess.spawnCloudParticles();
        }
    }

    @Override
    public boolean tryToTeleport(int x, int y, int z) {
        double bottomY = Math.max(y -= 8, this.method_37908().method_31607());
        double topY = Math.min(bottomY + 16.0, (double)(((class_3218)this.method_37908()).method_32819() - 1));
        for (int i = 0; i < 16; ++i) {
            boolean teleportResult = this.method_6082(x, y = (int)class_3532.method_15350((double)(y + 1), (double)bottomY, (double)topY), z, false);
            if (!teleportResult) continue;
            return true;
        }
        return false;
    }

    private void playMirrorSound() {
        this.method_5783(class_3417.field_14941, this.method_6107(), this.method_6017());
    }

    @Override
    public void spawnCloudParticles() {
        this.spawnParticles(class_2398.field_11204, 16);
    }

    private void spawnParticles(class_2400 particleType, int amount) {
        if (this.method_37908().method_8608()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((class_3218)this.method_5770()).method_14199((class_2394)particleType, this.method_23322(0.5), this.method_23319() + 0.5, this.method_23325(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean isIllusion() {
        return (Boolean)this.field_6011.method_12789(IS_ILLUSION);
    }

    @Override
    public void setIsIllusion(boolean isIllusion) {
        this.field_6011.method_12778(IS_ILLUSION, (Object)isIllusion);
    }

    public boolean wasAttacked() {
        return (Boolean)this.field_6011.method_12789(WAS_ATTACKED);
    }

    public void setWasAttacked(boolean wasAttacked) {
        this.field_6011.method_12778(WAS_ATTACKED, (Object)wasAttacked);
    }

    @Nullable
    public class_1581 getIllusioner() {
        return this.illusioner;
    }

    @Override
    public void setIllusioner(class_1581 illusioner) {
        this.illusioner = illusioner;
    }

    public int getTicksUntilDespawn() {
        return (Integer)this.field_6011.method_12789(TICKS_UNTIL_DESPAWN);
    }

    @Override
    public void setTicksUntilDespawn(int ticksUntilDespawn) {
        this.field_6011.method_12778(TICKS_UNTIL_DESPAWN, (Object)ticksUntilDespawn);
    }

    public int getTicksUntilCanCreateIllusions() {
        return (Integer)this.field_6011.method_12789(TICKS_UNTIL_CAN_CREATE_ILLUSIONS);
    }

    public void setTicksUntilCanCreateIllusions(int ticksUntilCanCreateIllusions) {
        this.field_6011.method_12778(TICKS_UNTIL_CAN_CREATE_ILLUSIONS, (Object)ticksUntilCanCreateIllusions);
    }
}

